dofile(LockOn_Options.script_path.."SHKVAL\\SHKVAL_usefull_definitions.lua")
SetScale(FOV)
local imported_from_3DMAX_indices =
{ 0 ,   41 ,   25 ,
 25 ,   44 ,    0 ,
 13 ,   42 ,   25 ,
 25 ,   41 ,   13 ,
  9 ,   43 ,   25 ,
 25 ,   42 ,    9 ,
 16 ,   44 ,   25 ,
 25 ,   43 ,   16 ,
  5 ,   45 ,   26 ,
 26 ,   47 ,    5 ,
 14 ,   46 ,   26 ,
 26 ,   45 ,   14 ,
  9 ,   42 ,   26 ,
 26 ,   46 ,    9 ,
 13 ,   47 ,   26 ,
 26 ,   42 ,   13 ,
  4 ,   48 ,   27 ,
 27 ,   50 ,    4 ,
 15 ,   49 ,   27 ,
 27 ,   48 ,   15 ,
  9 ,   46 ,   27 ,
 27 ,   49 ,    9 ,
 14 ,   50 ,   27 ,
 27 ,   46 ,   14 ,
  8 ,   51 ,   28 ,
 28 ,   52 ,    8 ,
 16 ,   43 ,   28 ,
 28 ,   51 ,   16 ,
  9 ,   49 ,   28 ,
 28 ,   43 ,    9 ,
 15 ,   52 ,   28 ,
 28 ,   49 ,   15 ,
  1 ,   53 ,   29 ,
 29 ,   56 ,    1 ,
 17 ,   54 ,   29 ,
 29 ,   53 ,   17 ,
 10 ,   55 ,   29 ,
 29 ,   54 ,   10 ,
 19 ,   56 ,   29 ,
 29 ,   55 ,   19 ,
  6 ,   57 ,   30 ,
 30 ,   59 ,    6 ,
 18 ,   58 ,   30 ,
 30 ,   57 ,   18 ,
 10 ,   54 ,   30 ,
 30 ,   58 ,   10 ,
 17 ,   59 ,   30 ,
 30 ,   54 ,   17 ,
  4 ,   50 ,   31 ,
 31 ,   61 ,    4 ,
 14 ,   60 ,   31 ,
 31 ,   50 ,   14 ,
 10 ,   58 ,   31 ,
 31 ,   60 ,   10 ,
 18 ,   61 ,   31 ,
 31 ,   58 ,   18 ,
  5 ,   62 ,   32 ,
 32 ,   45 ,    5 ,
 19 ,   55 ,   32 ,
 32 ,   62 ,   19 ,
 10 ,   60 ,   32 ,
 32 ,   55 ,   10 ,
 14 ,   45 ,   32 ,
 32 ,   60 ,   14 ,
  3 ,   63 ,   33 ,
 33 ,   66 ,    3 ,
 20 ,   64 ,   33 ,
 33 ,   63 ,   20 ,
 11 ,   65 ,   33 ,
 33 ,   64 ,   11 ,
 22 ,   66 ,   33 ,
 33 ,   65 ,   22 ,
  7 ,   67 ,   34 ,
 34 ,   69 ,    7 ,
 21 ,   68 ,   34 ,
 34 ,   67 ,   21 ,
 11 ,   64 ,   34 ,
 34 ,   68 ,   11 ,
 20 ,   69 ,   34 ,
 34 ,   64 ,   20 ,
  4 ,   61 ,   35 ,
 35 ,   71 ,    4 ,
 18 ,   70 ,   35 ,
 35 ,   61 ,   18 ,
 11 ,   68 ,   35 ,
 35 ,   70 ,   11 ,
 21 ,   71 ,   35 ,
 35 ,   68 ,   21 ,
  6 ,   72 ,   36 ,
 36 ,   57 ,    6 ,
 22 ,   65 ,   36 ,
 36 ,   72 ,   22 ,
 11 ,   70 ,   36 ,
 36 ,   65 ,   11 ,
 18 ,   57 ,   36 ,
 36 ,   70 ,   18 ,
  2 ,   73 ,   37 ,
 37 ,   76 ,    2 ,
 23 ,   74 ,   37 ,
 37 ,   73 ,   23 ,
 12 ,   75 ,   37 ,
 37 ,   74 ,   12 ,
 24 ,   76 ,   37 ,
 37 ,   75 ,   24 ,
  8 ,   52 ,   38 ,
 38 ,   78 ,    8 ,
 15 ,   77 ,   38 ,
 38 ,   52 ,   15 ,
 12 ,   74 ,   38 ,
 38 ,   77 ,   12 ,
 23 ,   78 ,   38 ,
 38 ,   74 ,   23 ,
  4 ,   71 ,   39 ,
 39 ,   48 ,    4 ,
 21 ,   79 ,   39 ,
 39 ,   71 ,   21 ,
 12 ,   77 ,   39 ,
 39 ,   79 ,   12 ,
 15 ,   48 ,   39 ,
 39 ,   77 ,   15 ,
  7 ,   80 ,   40 ,
 40 ,   67 ,    7 ,
 24 ,   75 ,   40 ,
 40 ,   80 ,   24 ,
 12 ,   79 ,   40 ,
 40 ,   75 ,   12 ,
 21 ,   67 ,   40 ,
 40 ,   79 ,   21 }

local imported_from_3DMAX_vertices =	
{--X			-Z		 -Y
{0.6637,	0.0970	,-0.4713},
{0.6637,	-0.1067	,-0.4713},
{0.6630,	0.0970	,-0.3327},
{0.6630,	-0.1067	,-0.3327},
{0.6481,	-0.0049	,-0.4020},
{0.6570,	-0.0049	,-0.4713},
{0.6584,	-0.1067	,-0.4020},
{0.6562,	-0.0049	,-0.3327},
{0.6584,	0.0970	,-0.4020},
{0.6534,	0.0460	,-0.4367},
{0.6534,	-0.0558	,-0.4367},
{0.6530,	-0.0558	,-0.3674},
{0.6531,	0.0460	,-0.3674},
{0.6587,	0.0460	,-0.4713},
{0.6506,	-0.0049	,-0.4367},
{0.6511,	0.0460	,-0.4020},
{0.6598,	0.0970	,-0.4367},
{0.6598,	-0.1067	,-0.4367},
{0.6511,	-0.0558	,-0.4020},
{0.6587,	-0.0558	,-0.4713},
{0.6579,	-0.0558	,-0.3327},
{0.6502,	-0.0049	,-0.3673},
{0.6594,	-0.1067	,-0.3674},
{0.6594,	0.0970	,-0.3674},
{0.6580,	0.0460	,-0.3327},
{0.6583,	0.0715	,-0.4540},
{0.6542,	0.0206	,-0.4540},
{0.6496,	0.0206	,-0.4193},
{0.6550,	0.0715	,-0.4193},
{0.6583,	-0.0813	,-0.4540},
{0.6550,	-0.0813	,-0.4193},
{0.6496,	-0.0304	,-0.4193},
{0.6542,	-0.0304	,-0.4540},
{0.6577,	-0.0813	,-0.3500},
{0.6536,	-0.0304	,-0.3500},
{0.6494,	-0.0304	,-0.3847},
{0.6548,	-0.0813	,-0.3847},
{0.6578,	0.0715	,-0.3500},
{0.6548,	0.0715	,-0.3847},
{0.6494,	0.0206	,-0.3847},
{0.6537,	0.0206	,-0.3500},
{0.6604,	0.0715	,-0.4713},
{0.6558,	0.0460	,-0.4540},
{0.6563,	0.0715	,-0.4367},
{0.6611,	0.0970	,-0.4540},
{0.6535,	-0.0049	,-0.4540},
{0.6514,	0.0206	,-0.4367},
{0.6575,	0.0206	,-0.4713},
{0.6489,	0.0206	,-0.4020},
{0.6518,	0.0460	,-0.4193},
{0.6488,	-0.0049	,-0.4193},
{0.6588,	0.0970	,-0.4194},
{0.6544,	0.0715	,-0.4020},
{0.6611,	-0.1067	,-0.4540},
{0.6563,	-0.0813	,-0.4367},
{0.6559,	-0.0558	,-0.4540},
{0.6604,	-0.0813	,-0.4713},
{0.6544,	-0.0813	,-0.4020},
{0.6518,	-0.0558	,-0.4193},
{0.6588,	-0.1067	,-0.4194},
{0.6514,	-0.0304	,-0.4367},
{0.6489,	-0.0304	,-0.4020},
{0.6575,	-0.0304	,-0.4713},
{0.6597,	-0.0813	,-0.3327},
{0.6553,	-0.0558	,-0.3500},
{0.6560,	-0.0813	,-0.3674},
{0.6605,	-0.1067	,-0.3500},
{0.6530,	-0.0049	,-0.3500},
{0.6510,	-0.0304	,-0.3674},
{0.6567,	-0.0304	,-0.3327},
{0.6516,	-0.0558	,-0.3847},
{0.6486,	-0.0049	,-0.3847},
{0.6586,	-0.1067	,-0.3847},
{0.6606,	0.0970	,-0.3500},
{0.6560,	0.0715	,-0.3674},
{0.6553,	0.0460	,-0.3500},
{0.6597,	0.0715	,-0.3327},
{0.6516,	0.0460	,-0.3847},
{0.6587,	0.0970	,-0.3847},
{0.6510,	0.0206	,-0.3674},
{0.6568,	0.0206	,-0.3327},
}

-- normalize coordinates, swap axis etc.
local min_X     = 1e5
local average_Y = 0
local average_Z = 0
local count = 0
for i,o in ipairs(imported_from_3DMAX_vertices) do
	if o[1] < min_X then
	   min_X = o[1]
	end
	average_Y = average_Y + o[3]
	average_Z = average_Z + o[2]
	
	count = count + 1
end

average_Y = average_Y / count
average_Z = average_Z / count

local imported_from_3DMAX_vertices_normed = {}
for i,o in ipairs(imported_from_3DMAX_vertices) do
	imported_from_3DMAX_vertices_normed[i] = {(o[2] - average_Z)/GetScale(),
											  (o[3] - average_Y)/GetScale(),
											  (o[1] - min_X)    /GetScale()}
end

amax   = 0.102/GetScale()
bmax   = 0.0695/GetScale()

render_tv					= CreateElement "ceTexPoly"
render_tv.name				= "screen"
--render_tv.primitivetype    = "lines"
render_tv.vertices			= imported_from_3DMAX_vertices_normed 
render_tv.indices			= imported_from_3DMAX_indices 
render_tv.tex_params		= {0.5, 0.5, 1/(2*amax), 1/(2*bmax)}
render_tv.material			= "render_target_1"

local x_shift = 0.0005 --0.0092369199999999818
render_tv.init_pos			= {0,0,x_shift/ GetScale()}
render_tv.h_clip_relation   = h_clip_relations.REWRITE_LEVEL
render_tv.level		  	    = DEFAULT_LEVEL + 1
render_tv.controllers		= {{"render_purpose",render_purpose.GENERAL},{"tv_control"}}
Add(render_tv)

local ysize = GetAspect()

HUD_OnlyVerts  = {{-1,  ysize},
				  { 1,  ysize},
				  { 1, -ysize},
				  {-1, -ysize}}

frame                                       = CreateElement "ceMeshPoly"
frame.name                                  = "fr"
frame.primitivetype                         = "lines"
frame.material                              = "BLACK2"
frame.vertices                  			= HUD_OnlyVerts
frame.indices			                    = {0,1,1,2,2,3,3,0}
frame.controllers                           = {{"render_purpose",render_purpose.HUD_ONLY_VIEW,
															     render_purpose.SCREENSPACE_OUTSIDE_COCKPIT,
																 render_purpose.SCREENSPACE_INSIDE_COCKPIT},{"tv_control"}}
Add(frame)

render_tv_in_HUD_only_view					= CreateElement "ceTexPoly"
render_tv_in_HUD_only_view.name				= "render_tv_in_HUD_only_view"
render_tv_in_HUD_only_view.vertices			= HUD_OnlyVerts
render_tv_in_HUD_only_view.indices			= {0, 1, 2, 0, 2, 3}
render_tv_in_HUD_only_view.tex_coords 		= {{0,0},{1,0},{1,1},{0,1}}
render_tv_in_HUD_only_view.material			= "render_target_1"
render_tv_in_HUD_only_view.parent_element   =  frame.name
Add(render_tv_in_HUD_only_view)

if LockOn_Options.flight.easy_radar then

frame2                                       = Copy(frame)
frame2.controllers                           = {{"render_purpose",render_purpose.SCREENSPACE_OUTSIDE_COCKPIT},{"tv_control"}}
Add(frame2)

render_tv_in_HUD_arcade					 =  Copy(render_tv_in_HUD_only_view)
render_tv_in_HUD_arcade.parent_element   =  frame2.name
Add(render_tv_in_HUD_arcade)
end





